﻿//////////////////////////////////////////////
// ScrollBar.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkWinUi
{
	class System ;
}

/// Includes ---------------------------------

// nkWinUi
#include "Component.h"

#include "../Dll/DllDefines.h"

// nkMemory
#include <NilkinsMemory/Pointers/UniquePtr.h>

// Standards
#include <functional>

/// Class ------------------------------------

namespace nkWinUi
{
	class DLL_WINUI_EXPORT ScrollBar : public Component
	{
		public :
	
			// Constructor, destructor
			ScrollBar (System* system) noexcept ;
			virtual ~ScrollBar () ;

			// Getters
			int getCurrentMin () const ;
			int getCurrentMax () const ;

			// Setters
			virtual void setMin (int value) ;
			virtual void setMax (int value) ;
			virtual void setActiveRange (int value) ;
			void setScrollCallback (std::function<void (ScrollBar*)> callback) ;
			virtual void scrollToMin () ;
			virtual void scrollToMax () ;
			virtual void setScrollFactor (float value) = 0 ;
			virtual void moveCurrentMinTo (int value) ;
			virtual void moveCurrentMaxTo (int value) ;

			// Helpers
			virtual void scroll (float factor) = 0 ;

		public :

			// Statics
			static nkMemory::UniquePtr<ScrollBar> create (System* system = nullptr) ;

		protected :

			// Attributes
			// Callback when scrolling
			std::function<void (ScrollBar*)> _scrollCallback ;

			// Limits
			int _min ;
			int _max ;

			// Current state
			int _currentMin ;
			int _currentMax ;
	} ;
}